<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Appointment extends Model 
{

    protected $table = 'appointments';
    public $timestamps = true;
    protected $fillable = array('clinic_id', 'doctor_id', 'client_name', 'phone', 'payment_type', 'national_number', 'gender', 'status', 'phone_verified', 'birthdate', 'start_date', 'end_date', 'date');

    public function clinic()
    {
        return $this->belongsTo('Clinic', 'clinic_id');
    }

    public function doctor()
    {
        return $this->belongsTo('Doctor', 'doctor_id');
    }

}